//
//  MCDaemon.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-02-08.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <Foundation/Foundation.h>


@interface MCDaemon : NSObject {
	
	NSDictionary *launchdPlist;
	NSTimer *daily;
	NSTimer *weekly;
	NSTimer *monthly;

	BOOL finished;
	int returnCode;
}

@property (readonly, retain) NSDictionary *launchdPlist;
@property (readwrite) BOOL finished;  // set when done working; MCDaemonMain() will exit the main loop, invoke -cleanup, and exit
@property (nonatomic, readwrite) int returnCode; // returned from MCDaemonMain()


// Automatically initialized by the first instance of this or a subclass to be created
// The whole point of a daemon is to be, like an application instance, a singleton
+ (MCDaemon *)daemon;

// Convert list of arguments into a dictionary of options; supports multiple arguments per option (so all values are arrays)
// The only pre-set option is -s, which means "look for options on standard input", used when launching a daemon as a task, for security
// use NSTaskRunning and provide one of the following arguments to the -s option:
// string: the passed-through data is a UTF8-encoded string
// plist: the passed-through data is a serialized property list
// object: the passed-through data is an archive made with NSKeyedArchiver, and will be unarchived with NSKeyedUnarchiver
+ (NSDictionary *)commandLineOptions;
// calls through to the above, and if the command line options specify stdin data, reads that and populates the dictionary as follows:
// string: decoded string
// plist: unserialized property list
// object: unarchived object graph
// if there were additional options provided at the command line, these will be included into the launchOptions dictionary (the s option will be removed)
+ (NSDictionary *)launchOptions;

- (NSDictionary *)checkInWithLaunchdReturningPropertyList;

/*
 * All methods are designed to be overridden.
 */

// Default is YES
- (BOOL)printGreetings;
// Default is YES if HOSTED, NO otherwise
- (BOOL)useSyslog;
// Simple starting/stopping message with program name
- (NSString *)helloMessage;
- (NSString *)goodbyeMessage;

// If -setup returns NO, the daemon won't be started
// Do things that can fail in -setup; use -start to begin processing
- (BOOL)setup;

// invokes -performDailyMaintenance
- (void)cleanup;

// begin working; when finished, set finished flag and return
- (void)start;

// schedules timers to invoke the -perform...Maintenance methods below; subclasses which run persistently should invoke this in start
- (void)scheduleMaintenance;
// because months have varying lengths, the monthly maintenance schedule is not set to repeat, but is rescheduled as part of execution
- (void)scheduleMonthlyMaintenance;

// The daily maintenance rotates log files; weekly does nothing; monthly merely invokes -scheduleMonthlyMaintenance
// subclasses should call super in case these change
- (void)performDailyMaintenance;
- (void)performWeeklyMaintenance;
- (void)performMonthlyMaintenance;

// Override with your preferred log file name; this should match the file name stored in the launchd job plist (which is set by MCDaemonKeeper)
// By default attempts to retrieve the information from launchd (but that currently doesn't work)
- (NSString *)logFilePath;
- (int)logFacility;

// subclasses should implement at least one of these
- (NSString *)eventTrackerDatabaseFileName; // Put it somewhere sensible; by default "com.marketcircle.<TOOLNAME>.mclogdb"
- (NSString *)eventTrackerDatabasePath;     // Put it here; by default uses NSTemporaryFolder() and appends with above
- (void)createEventTracker;                 // I'll take care of it; by default; by default, calls the above

@end
